import type {NextConfig} from 'next';

const nextConfig: NextConfig = {
  /* config options here */
  typescript: {
    ignoreBuildErrors: true,
  },
  eslint: {
    ignoreDuringBuilds: true,
  },
  images: {
    remotePatterns: [
      {
        protocol: 'https',
        hostname: 'picsum.photos',
        port: '',
        pathname: '/**',
      },
    ],
  },
  // Исключаем папку ms4sc-mobile из сборки
  outputFileTracingExcludes: {
    '*': [
      'ms4sc-mobile/**/*',
      'node_modules/@swc/core-linux-x64-gnu',
      'node_modules/@swc/core-linux-x64-musl',
      'node_modules/@swc/core-darwin-x64',
      'node_modules/@swc/core-darwin-arm64',
      'node_modules/@swc/core-win32-x64-msvc',
    ],
  },
  // Настройки для production
  output: 'standalone',
  distDir: '.next',
  generateBuildId: async () => {
    return 'production-build-' + Date.now();
  },
};

export default nextConfig;
