# Инструкции по развертыванию MS4SC v6

## Обновления в этой версии

### Исправления:
1. **Исправлена проблема с ролями пользователей** - пользователи с ролью 2 теперь корректно получают интерфейс обычного пользователя
2. **Устранен конфликт источников данных о ролях** - теперь используется единый источник `userRoleId` из AuthContext
3. **Упрощена логика определения интерфейса** - убрана дублирующая проверка ролей в MainDashboard

### Файлы для развертывания:

#### 1. ms4sc-production-updated.zip (142 MB)
**Для быстрого обновления production сервера:**
- Содержит только скомпилированные файлы (.next)
- Включает все необходимые конфигурационные файлы
- Готов к развертыванию без пересборки

#### 2. ms4sc-source-updated.zip (9.5 MB)
**Для полного обновления с исходным кодом:**
- Содержит исходный код (src/)
- Включает все конфигурационные файлы
- Требует выполнения `npm install` и `npm run build`

## Инструкции по развертыванию

### Вариант 1: Быстрое обновление (рекомендуется)

1. **Остановите текущий сервер:**
   ```bash
   pm2 stop ms4sc
   # или
   systemctl stop ms4sc
   ```

2. **Создайте резервную копию:**
   ```bash
   cp -r /path/to/current/app /path/to/backup/app-$(date +%Y%m%d-%H%M%S)
   ```

3. **Распакуйте архив:**
   ```bash
   cd /path/to/app
   unzip ms4sc-production-updated.zip
   ```

4. **Запустите сервер:**
   ```bash
   pm2 start server.js --name ms4sc
   # или
   systemctl start ms4sc
   ```

### Вариант 2: Полное обновление

1. **Остановите сервер** (как в варианте 1)

2. **Распакуйте архив:**
   ```bash
   cd /path/to/app
   unzip ms4sc-source-updated.zip
   ```

3. **Установите зависимости:**
   ```bash
   npm install
   ```

4. **Создайте production сборку:**
   ```bash
   npm run build
   ```

5. **Запустите сервер:**
   ```bash
   pm2 start server.js --name ms4sc
   ```

## Проверка после развертывания

1. **Проверьте логи:**
   ```bash
   pm2 logs ms4sc
   ```

2. **Проверьте статус:**
   ```bash
   pm2 status
   ```

3. **Проверьте работу приложения:**
   - Откройте браузер и перейдите на ваш домен
   - Войдите как пользователь с ролью 2
   - Убедитесь, что отображается правильный интерфейс пользователя
   - Проверьте, что таб "заказ" скрывается при `order_tab = false`

## Откат (если что-то пошло не так)

1. **Остановите сервер:**
   ```bash
   pm2 stop ms4sc
   ```

2. **Восстановите из резервной копии:**
   ```bash
   rm -rf /path/to/app
   cp -r /path/to/backup/app-YYYYMMDD-HHMMSS /path/to/app
   ```

3. **Запустите сервер:**
   ```bash
   pm2 start server.js --name ms4sc
   ```

## Технические детали

### Исправленные файлы:
- `src/user-panel/MainDashboard.tsx` - убрана дублирующая логика ролей
- `src/context/auth-context.tsx` - используется как единый источник данных о ролях
- `src/app/dashboard/page.tsx` - централизованная логика маршрутизации по ролям

### Логика ролей:
- Роль 0: SystemMainDashboard (суперпользователь)
- Роль 1: ManagerMainDashboard (администратор)
- Роль 2: MainDashboard (обычный пользователь)

### Фильтрация табов:
- Таб "заказ" скрывается для пользователей с `order_tab = false`
- Логика работает корректно для всех ролей

## Поддержка

При возникновении проблем проверьте:
1. Логи приложения
2. Статус PM2/systemd
3. Доступность базы данных
4. Переменные окружения

Дата создания: 2 октября 2025
Версия: MS4SC v6 (исправленная)
