import { NextResponse } from 'next/server';
import { postgresClient } from '@/lib/postgresql-client';

export async function POST(request: Request) {
  try {
    const { role_id, permissions, current_user_role_id } = await request.json();
    if (current_user_role_id !== 0) {
      return NextResponse.json({ error: 'Forbidden' }, { status: 403 });
    }
    if (typeof role_id !== 'number' || typeof permissions !== 'object') {
      return NextResponse.json({ error: 'Invalid input' }, { status: 400 });
    }
    await postgresClient.query(
      'UPDATE roles SET permissions = $1 WHERE role_id = $2',
      [JSON.stringify(permissions), role_id]
    );
    return NextResponse.json({ success: true });
  } catch (error) {
    console.error('Failed to update role permissions:', error);
    return NextResponse.json({ error: 'Failed to update role permissions' }, { status: 500 });
  }
} 